#version 330

in vec3 vertex;
in vec3 normal;
uniform mat4 Projection;
uniform mat4 View;
uniform mat4 Model;
uniform float time;

float random_re[256] = float[256](0.8589352695,0.9386370046,0.2645235319,0.2601459306,-0.5641792426,-0.7675341599,-0.8282980959,1.7732906491,1.3969609456,-0.4021030534,0.4246105398,0.3210489310,1.3561529556,-1.5352826062,-0.1134926235,-0.5679785417,0.7490751038,-0.4259224352,0.3155119292,0.8853722878,-0.4282513912,0.7897374693,-1.0684133699,0.9830136848,0.1954789228,0.9612612950,0.4538906390,0.5831503972,-0.0152327603,-0.1055005415,-0.1657530634,1.3823573802,-0.0472696223,0.5376434285,0.9733632772,1.5639798240,0.7302904010,-1.4257342218,-0.1377578208,0.2857533254,-0.1079919738,1.2382634307,-0.1839372164,1.5166098880,-0.0316888964,-0.5447322321,0.6421001106,-0.4784142615,0.2974653569,-1.2282493353,-0.3779775709,-0.9533181141,0.4556822755,0.2916787726,-1.1829006755,-0.3303696508,-1.3244779085,-0.5555069581,0.7798043421,0.1142026489,-1.3483315698,-1.0600836893,1.8395105040,0.5402631736,-0.6408413750,0.9848668519,0.1099288094,0.1216222428,-1.1616902365,-0.6633802577,0.3880862709,1.1081946201,-1.2351077867,0.3652206198,0.0803745267,-0.0396370685,-1.2291871382,-0.3073815406,0.3979659369,-0.9660873203,0.2165559794,-1.4140416730,0.4382205819,1.5068218711,0.1617380193,1.5276921483,-0.0362835765,-1.5488382965,-0.5482907333,-0.4055517704,-0.6861007932,1.1189697819,-1.2154891503,0.1585772394,-0.0810909534,0.4474234372,0.6084303506,-1.9403092194,1.1701666787,0.2926508416,0.0661317225,-2.2678846594,-0.5815417111,0.0007401396,-1.7884113517,1.6262752859,-0.7646193844,0.2578313081,-0.8721283817,0.8332560840,0.4238687317,0.3932940974,-0.0290995406,0.3516927229,0.7686163354,-1.1905454071,-0.7123631284,0.4644552964,-0.7535996642,2.0744346705,-0.2365346934,1.2042155537,0.3800886516,-1.5162023176,0.3985335899,1.6348461666,1.3686311654,-0.1929091173,-1.4264027198,0.8844368343,-1.9929018426,0.3646876795,1.1317619530,1.4511540520,-0.9103020019,-1.0374084343,-1.9461942509,-0.6279189919,-0.7850301070,0.6252578186,0.1584741440,-0.7096359957,-0.0780745975,-0.8085547965,-1.8293231735,0.8588371941,0.5598825271,0.4570551250,0.6172570229,0.7306976302,0.1677601179,0.3702553306,-1.2227451011,0.3674228545,0.4475446416,-0.5274899823,0.4752897542,-1.8012359210,-1.9965838024,0.8733159557,-2.3789859204,-0.1715657999,-1.0764194963,1.7493114739,-0.3800857275,-0.7556335561,1.0129378595,1.8552074224,-2.2236183178,0.3205325247,0.7094563666,2.4468263354,-0.9539386272,-0.8531230790,-0.3885759392,-1.4107184759,-1.4052936797,-0.2508073552,-0.3345891994,-1.5242437167,-1.1420142692,0.0366933649,-1.0718099051,0.2643414891,0.2296325904,-0.6919215182,1.0230897316,-0.7050116947,0.7509347863,-1.0487903594,-0.0096138682,0.8465365329,0.2545182824,1.6700155405,1.8228979106,2.3641808946,-0.3340488062,0.0202902938,-0.9098437751,-0.4883321048,0.4021629210,0.2812004385,-1.3686591405,0.8426540989,-0.9473567250,0.6210856315,0.7022180157,-0.6794733833,-1.2021048209,0.0235047473,1.1534788824,0.9764001860,-0.0493900731,-0.3254236951,0.9421474731,1.5437327690,0.5570118700,-1.6995191020,2.1120976039,0.6572531185,0.5999853387,-0.1546240144,0.5329326761,0.3267965303,1.7534982806,1.0655323630,-1.5505352579,2.0629678190,-1.4443329522,1.2549029187,-0.9806437225,0.4139521837,-1.8322887732,-2.4461461043,0.2114791757,1.1664941089,0.3380627465,2.1535871065,-0.5487110575,1.2349239243,0.3067419757,-0.6085588777,-0.7671090667,-0.5181944254,-1.1051137262,-1.0813969034,-1.4643423063,0.6304293591,1.0722981423,-0.7206924058,0.7084764876,-0.2856935712,0.8168216359,0.3020161932,-0.6992944333,0.5786970607);
float random_im[256] = float[256](1.283300510,-0.337982784,-1.099458605,0.410550572,-0.241599137,1.943704747,0.038644804,-0.671304310,0.186440895,-0.001793220,1.141159884,-1.776602165,1.331748105,0.579754895,0.082498489,0.417630892,1.443618604,1.291885569,-0.778240466,1.225535543,1.067471774,-0.666608270,-0.224693653,-1.113932440,0.823617539,-0.097352734,0.433415368,1.215932008,0.360655775,0.675933904,-0.207195002,-0.569385615,-0.242449912,-0.391120619,1.172806959,-1.624366851,-1.924302840,1.092080775,1.490940061,0.242508242,-0.041414210,-1.058945530,0.884758452,1.682479839,0.741378616,-0.953473803,0.306269787,-0.533160092,0.022068089,-2.897545041,1.695554760,0.740985267,0.736368810,0.165535048,0.379484056,1.023961758,-1.133545067,1.183066287,0.212813617,0.336724716,0.590068770,0.174468881,-1.062856787,1.198298462,0.146490448,1.191537630,-0.066267167,-1.814894003,-0.869253854,-0.409042760,0.762573211,-0.846210357,0.536262355,0.732939680,0.184055431,0.065231938,0.368632277,-0.205155934,0.634686191,-0.592878656,-0.294085439,-0.275127653,0.512257000,1.446181276,-0.442829526,1.751113864,-0.291397943,0.775010384,0.923736822,-2.244196208,0.974393781,-0.344365651,-0.157537181,-1.054415228,0.682924919,1.518881617,-0.904423002,-0.235753127,1.431359665,1.329755249,0.204804002,1.077415948,1.070436406,0.193512710,-0.959972440,-0.000120610,-0.395258716,-1.058108898,-0.044171295,-1.181383654,-0.261433107,2.687186538,0.398907755,-0.681414058,-0.017488964,-0.421779861,-1.570444988,0.901671339,1.045406488,-0.369281703,2.227458388,0.615837842,-0.721389764,2.504111317,1.007662352,0.722887880,0.386336918,0.285354533,0.090507564,0.740651745,-0.399622869,-0.248007971,-0.784752922,0.112734386,0.996519902,-0.618666702,0.114502591,1.376501760,-1.068106984,-0.940594186,0.825332826,-0.970663301,0.604604394,0.698520677,-0.204855365,1.077975944,0.801425114,0.313588431,0.484455378,0.047833239,1.128333924,1.023353503,-0.172052583,0.069787269,1.812909565,-0.990520161,-0.679826000,0.125433873,-0.807404309,-1.102696076,-1.147160272,0.752136747,2.252073499,-1.363440189,0.990219895,0.496955463,0.881086908,1.282355715,-0.498577246,1.020761231,0.391375244,-0.081802604,-0.462155718,-1.341911564,-0.244638420,0.341471788,-0.014976427,0.264966106,0.092276718,0.552385910,0.441106011,0.168071016,-0.291836438,0.257574904,-0.028605401,0.319225340,0.277385948,0.890458712,1.335646702,-1.720587121,-0.232186697,0.315237451,1.025130316,-2.935729857,-0.463652381,-0.694259200,0.952960174,0.188507178,-0.935105938,-0.221966923,-0.522022888,-0.770107680,-0.356663497,0.428388130,-0.189812208,-0.901788018,0.663577877,-0.016443988,-0.487989556,1.100617173,-0.165975446,-1.144542853,-1.468082590,1.116654217,-0.264295159,-0.105343595,-1.077747372,0.923898720,0.847429101,2.100799585,0.995236205,-0.573230916,-0.451934891,1.426949459,0.203457756,0.024913212,-1.466017675,0.550035121,0.432978186,0.989186623,-0.272826884,0.563262710,-0.065456155,0.903216864,0.499387811,0.893218770,-0.701079239,1.803009693,-1.378490484,0.108665897,1.749039313,-0.328426826,-0.330235929,2.049254250,-0.858694461,-0.553426566,0.091422656,0.323004171,1.366488576,0.437015193,-0.115264240,-0.684245847,0.690775518,-0.040531646,0.625578034,1.676537262);

float phillipsSpectrum(vec2 k) {
	float A = 1;
	float g = 9.8;
	float V = 1;
	float L = pow(V,2)/g;
	float damping = 0.001;
	float term = exp(-pow(k.length(),2)*pow(V,4)/pow(g,2)*pow(damping,2));
	vec2 w = vec2(1.0, 0.0);
	return A * exp(-1 / pow((length(k) * L),2)) / pow(length(k),4) * pow(abs(dot(normalize(k),normalize(w))),2);
}

vec2 h0tilde(vec2 k, int i, int j) {
	int dim = 16;
	float pi = 3.14159265359;
	int offset = i + j * 16;
	float xi_r = random_re[offset]; //something to sample
	float xi_i = random_im[offset]; //something to sample
	//float xi_r = 0.5; //something to sample
	//float xi_i = 0.4; //something to sample
	float ps = sqrt(phillipsSpectrum(k)/2.0);
	return vec2(ps*xi_r, ps*xi_i);
}

vec2 conj(vec2 c) {
	return vec2(c.x, -c.y);
}

float omega(vec2 k) {
	float g = 9.8;
	return sqrt(g * length(k));
}

vec2 htilde(vec2 k, float t, int i, int j) {
	float o_kt = omega(k) * t;
	float cos_o_kt = cos(o_kt);
	float sin_o_kt = sin(o_kt);
	vec2 h0tilde_k      = h0tilde(k, i, j);
	vec2 h0tilde_k_conj = conj(h0tilde(-k, 16-i, 16-j)); // what is -k?
	vec2 c_0 = vec2(cos_o_kt,  sin_o_kt);
	vec2 c_1 = vec2(cos_o_kt, -sin_o_kt);
	return vec2(
		h0tilde_k.x*c_0.x - h0tilde_k.y*c_0.y + h0tilde_k_conj.x*c_1.x - h0tilde_k_conj.y*c_1.y,
		h0tilde_k.x*c_0.y + h0tilde_k.y*c_0.x + h0tilde_k_conj.x*c_1.y + h0tilde_k_conj.y*c_1.x
	);
}

vec2 h(vec2 x, float t) {

	int dim = 16;
	float pi = 3.14159265359;
	float L_x = 16.0;
	float L_y = 16.0;
	vec2 k;
	vec2 res = vec2(0.0, 0.0);
	vec2 htilde_kt;
	float cos_kx;
	float sin_kx;
	for (int j = -dim/2; j < dim/2; j++) {
		for (int i = -dim/2; i < dim/2; i++) {
			k.x = 2 * pi * i / L_x;
			k.y = 2 * pi * j / L_y;
			htilde_kt = htilde(k, t, i+dim/2, j+dim/2);
			cos_kx = cos(dot(k, x));
			sin_kx = sin(dot(k, x));
			res += vec2(
				htilde_kt.x * cos_kx - htilde_kt.y * sin_kx,
				htilde_kt.y * cos_kx + htilde_kt.x * sin_kx
			);
		}
	}

	return res;
}

void main() {
	vec3 v;
	v = vertex;
	//v.y = h(v.xz, time).x;

/*
	float pi = 3.14159265359;

	//vec2 w = normalize(vec2(1, 1));

	float lambda0 = 20.0;
	float lambda1 = 15.0;
	float lambda2 = 17.0;
	float lambda3 = 12.0;
	float lambda4 = 10.0;
	float lambda5 = 5.0;

	vec2 k0 = normalize(vec2( 1.0,  1.0 ))*2*pi/lambda0;
	vec2 k1 = normalize(vec2( 0.0,  1.0 ))*2*pi/lambda1;
	vec2 k2 = normalize(vec2(-1.0,  0.5 ))*2*pi/lambda2;
	vec2 k3 = normalize(vec2(-1.0, -0.5 ))*2*pi/lambda3;
	vec2 k4 = normalize(vec2(-1.0,  0.75))*2*pi/lambda4;
	vec2 k5 = normalize(vec2( 1.0, -0.5 ))*2*pi/lambda5;

	float xi_r0 = 0.15;
	float xi_r1 = 0.65;
	float xi_r2 = 0.55;
	float xi_r3 = 0.25;
	float xi_r4 = 0.75;
	float xi_r5 = 0.60;
	//float xi_i = 0.60;

	float h0_r0     = 1/sqrt(2)*xi_r0*sqrt(phillipsSpectrum(k0));
	float h0_r1     = 1/sqrt(2)*xi_r1*sqrt(phillipsSpectrum(k1));
	float h0_r2     = 1/sqrt(2)*xi_r2*sqrt(phillipsSpectrum(k2));
	float h0_r3     = 1/sqrt(2)*xi_r3*sqrt(phillipsSpectrum(k3));
	float h0_r4     = 1/sqrt(2)*xi_r4*sqrt(phillipsSpectrum(k4));
	float h0_r5     = 1/sqrt(2)*xi_r5*sqrt(phillipsSpectrum(k5));
	//float h0_i     = 1/sqrt(2)*xi_i*sqrt(phillipsSpectrum(k));

	float ht_r0 =  h0_r0 * (cos(omega(k0)*time));
	float ht_r1 =  h0_r1 * (cos(omega(k1)*time));
	float ht_r2 =  h0_r2 * (cos(omega(k2)*time));
	float ht_r3 =  h0_r3 * (cos(omega(k3)*time));
	float ht_r4 =  h0_r4 * (cos(omega(k4)*time));
	float ht_r5 =  h0_r5 * (cos(omega(k5)*time));
	//float ht_i = 0;

	v.y = 2 * ht_r0 * cos(dot(k0,v.xz));// +
//	      ht_r1 * cos(dot(k1,v.xz)) +
//	      ht_r2 * cos(dot(k2,v.xz)) +
//	      ht_r3 * cos(dot(k3,v.xz)) +
//	      ht_r4 * cos(dot(k4,v.xz)) +
//	      ht_r5 * cos(dot(k5,v.xz));
*/
/*
	vec3 k  = vec3(1.0, 0.0, 1.0);
	vec3 k1 = vec3(0.0, 0.0, 1.0);
	vec3 k2 = vec3(-1.0, 0.0, 0.5);

	float lambda  = 10;
	float lambda1 = 5;
	float lambda2 = 7;

	k  = normalize(k) *2*3.14159265359/lambda;
	k1 = normalize(k1)*2*3.14159265359/lambda1;
	k2 = normalize(k2)*2*3.14159265359/lambda2;

	float amplitude  = 0.8;
	float amplitude1 = 0.4;
	float amplitude2 = 0.25;

	float phi  = 0.5;
	float phi1 = 1.5;
	float phi2 = 2.0;

	float omega  = sqrt(9.8*2*3.14159265359/lambda);
	float omega1 = sqrt(9.8*2*3.14159265359/lambda1);
	float omega2 = sqrt(9.8*2*3.14159265359/lambda2);

	vec2 x = vertex.xz - (
		      (normalize(k)).xz*amplitude*sin(dot(k.xz,vertex.xz)-omega*time+phi) +
		      (normalize(k1)).xz*amplitude1*sin(dot(k1.xz,vertex.xz)-omega1*time+phi1) +
		      (normalize(k2)).xz*amplitude2*sin(dot(k2.xz,vertex.xz)-omega2*time+phi2)
		  );
	float y = (
			amplitude*cos(dot(k.xz,vertex.xz)-omega*time+phi) +
			amplitude1*cos(dot(k1.xz,vertex.xz)-omega1*time+phi1) +
			amplitude2*cos(dot(k2.xz,vertex.xz)-omega2*time+phi2)
		  );
	v.x = x.x; v.y = y; v.z = x.y;
*/

	gl_Position = Projection * View * Model * vec4(v, 1.0);
}