#ifndef TERRAIN_H
#define TERRAIN_H

#include <GL/glew.h>
#include <GL/gl.h>

#include <math.h>
#include "complex.h"
#include "vector.h"
#include "fft.h"
#include "glhelper.h"

#include "../glm-0.9.2.6/glm/glm.hpp"
#include "../glm-0.9.2.6/glm/gtc/matrix_transform.hpp"
#include "../glm-0.9.2.6/glm/gtc/type_ptr.hpp"



struct vertex_terrain {
	GLfloat   x,   y,   z; // vertex
	GLfloat  nx,  ny,  nz; // normal
	GLfloat  tx,  ty,  tz; // texture
	GLfloat  cx,  cy,  cz; // color
};



class cTerrain {
  private:
	int N, Nplus1;
	bool geometry;
	vertex_terrain *vertices;
	float *height_map;
	float scale, power;

	unsigned int *indices;			// indicies for vertex buffer object
	unsigned int indices_count;		// number of indices to render
	GLuint vbo_vertices, vbo_indices;	// vertex buffer objects

	GLuint glProgram, glShaderV, glShaderF;	// shaders
	GLint vertex, normal, texture, colorc, light_position, projection, view, model;	// attributes and uniforms
	GLint heightmap;

  protected:
  public:
	cTerrain(int N, float power, float scale, bool geometry);
	~cTerrain();
	vector3 color(double h, double min, double max);
	void release();
	void render(glm::vec3& light_pos, glm::mat4& Projection, glm::mat4& View, glm::mat4& Model);
};

#endif